### API函数一览表

下表列出了所使用的 PC  端函数及说明：

| 功能       | 名称                             | 功能说明              |
| -------- | ------------------------------ | ----------------- |
| 控制器配置函数  | Smc\_Get\_DllVersion           | 获取控制器动态库文件版本号     |
|          | Smc\_Open                      | 控制器连接初始化函数，分配系统资源 |
|          | Smc\_Close                     | 控制器关闭函数，释放系统资源    |
| 状态监控     | Smc\_Get\_PowerStatus          | 获取轴使能状态           |
|          | Smc\_Get\_AxisStatus           | 获取轴状态             |
|          | Smc\_Get\_ActPosition          | 获取指定轴实际运动的位置      |
|          | Smc\_Get\_TargetPosition       | 获取指定轴规划运动位置       |
|          | Smc\_Get\_ActVelocity          | 获取指定轴实际运动的速度      |
|          | Smc\_Get\_TargetVelocity       | 获取指定轴规划速度         |
|          | Smc\_Get\_ActAcceleration      | 获取指定轴实际运动的加速度     |
| 单轴速度参数   | Smc\_Set\_MoveSpeed            | 设置指定轴 Move 运动速度   |
|          | Singel\_Get\_MoveSpeed         | 获取指定轴 Move 运动速度   |
|          | Smc\_Set\_JogSpeed             | 设置指定轴 Jog 运动速度    |
|          | Singel\_Get\_JogSpeed          | 获取指定轴 Jog 运动速度    |
| 单轴操作     | Smc\_Axis\_Enable              | 单轴上使能             |
|          | Smc\_Axis\_Disable             | 单轴下使能             |
|          | Smc\_Get\_PowerStatus          | 获取轴使能状态           |
|          | Smc\_Get\_AxisStatus           | 获取轴状态             |
|          | Smc\_Axis\_Reset               | 轴复位               |
| 单轴运动     | Smc\_MoveAbsolute              | 绝对位置运动            |
|          | Smc\_MoveRelative              | 相对位置运动            |
|          | Smc\_MoveJog                   | Jog 运动            |
|          | Smc\_WaitForAxisStop           | 等待轴停止             |
|          | Smc\_MoveStop                  | 指定轴停止             |
| 回原点运动    | AxisHome                       | 单轴回原点             |
|          | Smc\_HomeByGroup               | 分组回原点             |
| 通用 IO 操作 | Smc\_IO\_WriteDO               | 设置指定输出端口信号        |
|          | Smc\_IO\_WriteDO\_Flash        | 设置指定输出端口闪烁信号      |
|          | Smc\_IO\_ReadDI                | 获取指定输入端口信号        |
|          | Smc\_IO\_Set\_ForceSwitch\_DI  | 设置指定输入端口的强制信号     |
|          | Smc\_IO\_Set\_ForceValue\_DI   | 设置指定输入端口的强制值      |
|          | Smc\_IO\_Set\_ForceSwitch\_DO  | 设置指定输出端口的强制信号     |
|          | Smc\_IO\_Set\_ForceValue\_DO   | 设置指定输出端口的强制值      |
|          | Smc\_IO\_Get\_DigitIOStatus    | 获取数字量 IO 的状态      |
|          | Smc\_IO\_ReadDO                | 获取指定输出端口信号状态      |
| 模拟量IO    | Smc\_IO\_ReadAO                | 读模拟量输出            |
|          | Smc\_IO\_WriteAO               | 写模拟量输出            |
|          | Smc\_IO\_Set\_ForceSwitch\_AO  | 设置模拟量强制输出开关       |
|          | Smc\_IO\_Set\_ForceValue\_AO   | 设置模拟量强制输出值        |
| 特殊 IO 功能 | MoveAbsoluteAndMemOutIO        | 绝对运动同步输出内存信号      |
|          | Smc\_IO\_WriteMemIO            | 写内存位 IO           |
|          | Smc\_IO\_ReadMemIO             | 读内存位 IO           |
|          | Smc\_IO\_WriteDO\_PWM          | 写 PWM 信号          |
|          | Smc\_IO\_WriteDO\_PSO          | 写 PSO 信号          |
| 软件限位相关函数 | Smc\_Set\_SoftwareLimits       | 设置软件限位            |
|          | Smc\_ActivateSoftwareLimits    | 激活软件限位            |
|          | Smc\_Get\_SoftwareLimits       | 获取软件限位            |
| CNC      | Smc\_CNC\_BeginTransmit        | 开始下载              |
|          | Smc\_CNC\_EndTransmit          | 结束下载              |
|          | Smc\_CNC\_Transmit             | 下载 GCode          |
|          | Smc\_CNC\_BeginRead            | 开始上载              |
|          | Smc\_CNC\_ExecuteReadLine      | 上载 GCode          |
|          | Smc\_CNC\_EndRead              | 结束上载              |
|          | Smc\_CNC\_ExecuteInterpolation | 运行 CNC 插补         |
|          | Smc\_CNC\_IsFinished           | CNC 插补是否完成        |
|          | Smc\_CNC\_Pause                | 暂停/继续 CNC         |
|          | Smc\_CNC\_SetOverride          | 设置 CNC 运动速率       |
|          | Smc\_CNC\_StopInterpolation    | 停止 CNC 插补         |
|          | Smc\_CNC\_Reset                | 复位 cnc            |
|          | Smc\_CNC\_Get\_Info            | 获取 CNC 信息         |
|          | Smc\_CNC\_Get\_AxisMapID       | 获取 CNC 轴映射 ID     |
|          | Sgmc\_CNC\_Set\_AxisMapID      | 设置 CNC 轴映射 ID     |
|          | Smc\_CNC\_Get\_GCodeMD5        | 获取 MD5 值          |
|          | Smc\_CNC\_Set\_GCodeMD5        | 设置 MD5 值          |
| 其他       | Smc\_Get\_EncoderIn            | 获取外部编码器的值         |
|          | Smc\_Set\_EncoderOffset        | 设置外部编码器的值         |

---

### 指令运行错误一览表

| 错误号 | 错误代码                     | 可能错误原因              |
| --- | ------------------------ | ------------------- |
| -2  | Error\_Init              | 初始化错误               |
| -1  | Communication\_Error     | 通讯错误                |
| 0   | NoError                  | 没有错误                |
| 1   | Error\_Unknow            | 未知错误                |
| 2   | Error\_FB                | FB 错误               |
| 3   | Error\_AxisIsRunning     | 轴在运行错误              |
| 4   | Error\_AxisIsPowerOn     | 轴使能错误               |
| 5   | Error\_AxisIsNotReady    | 轴没有准备好错误            |
| 6   | Error\_NoFindThisCommand | 没有找到这个 Command 指令错误 |
| 7   | Error\_StatusError       | 状态错误                |
| 8   | Error\_Transmit          | 下载错误                |
| 9   | Error\_BeginTransmit     | 开始下载错误              |
| 10  | Error\_EndTransmit       | 结束下载错误              |